//
// Fragment shader for Color Posterize effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;
uniform vec4 textureRect;
varying vec2 gUV;

uniform float gammaValue;
uniform int numOfColors;

void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        vec4 outColor = texture2DRect(texUnit, gUV);
        outColor.rgb = pow(outColor.rgb, vec3(gammaValue, gammaValue, gammaValue));
        outColor = outColor * float(numOfColors);
        outColor = floor(outColor);
        outColor = outColor /  float(numOfColors);
        outColor.rgb = pow(outColor.rgb, vec3(1.0/gammaValue));
        gl_FragColor = modulateColor*vec4(outColor.rgb, outColor.a);
    }
}

